/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.frame.sequencenumbers;

import com.sap.customercheckout.tools.restore.controller.NextFrameListener;
import com.sap.customercheckout.tools.restore.frame.base.BaseSequenceNumberFrame;
import com.sap.customercheckout.tools.restore.helper.CCOHelper;
import com.sap.customercheckout.tools.restore.helper.CCOmHelper;
import com.sap.scco.util.exception.WrongConfigurationException;
import com.sap.scco.util.translation.Translator;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiptSequenceNumberFrame
extends BaseSequenceNumberFrame {
    private static final Logger logger = LoggerFactory.getLogger(ReceiptSequenceNumberFrame.class);
    private static final String SEQUENCE_NUMBER_TYPE = "RECEIPT";
    private CCOmHelper mHelper;

    public ReceiptSequenceNumberFrame(CCOHelper helper, CCOmHelper monitorHelper, String ccoPrefix, NextFrameListener listener) {
        super(listener, helper, Translator.T((String)SEQUENCE_NUMBER_TYPE), SEQUENCE_NUMBER_TYPE, false);
        this.mHelper = monitorHelper;
        String currentSquenceNumber = helper.getSequenceNumberCurrentNumber(SEQUENCE_NUMBER_TYPE);
        String sequenceNumberPattern = helper.getSequenceNumberPattern(SEQUENCE_NUMBER_TYPE);
        String lastId = helper.getLastReceiptId();
        String lastIdFromManager = null;
        try {
            if (this.mHelper == null) {
                this.mHelper = new CCOmHelper(helper);
            }
            lastIdFromManager = this.mHelper.getLastReceiptFromServer(ccoPrefix);
        }
        catch (WrongConfigurationException e1) {
            logger.error("Connection to CCOm not configured.", (Throwable)e1);
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_MANAGER_CONNECTION_NOT_CONFIGURED"));
        }
        catch (Exception e2) {
            logger.error("Failure during sequence number preparation", (Throwable)e2);
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_MANAGER_CONNECTION") + "\n");
        }
        this.setSequenceNumberFields(ccoPrefix, currentSquenceNumber, sequenceNumberPattern, lastId, lastIdFromManager);
        this.buttonNextScreen.addActionListener(e -> listener.openNextFrame(this, helper, this.mHelper, ccoPrefix));
    }
}

