/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.frame.prefixchanger;

import com.sap.customercheckout.tools.restore.controller.NextFrameListener;
import com.sap.customercheckout.tools.restore.frame.base.BaseFrame;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.CashDeskSettings;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.ERPSettings;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.SettingsChangeResult;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.SettingsChanger;
import com.sap.customercheckout.tools.restore.helper.CCOHelper;
import com.sap.scco.ap.pos.dao.CDBSession;
import com.sap.scco.ap.pos.dao.CDBSessionFactory;
import com.sap.scco.util.translation.Translator;
import com.sap.scco.util.utilities.SecurityHelpers;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixChangerFrame
extends BaseFrame {
    private static final long serialVersionUID = 6077565836343175430L;
    private String ccoPrefix = "";
    private CCOHelper ccoHelper = null;
    private transient SettingsChanger settingsChanger = null;
    private JButton btnChangeSettings;
    private final Map<String, List<Component>> changeComponents = new HashMap<String, List<Component>>();
    private int yPosition = 20;
    private boolean isSettingsComponentsAdded = false;
    private static final Logger logger = LoggerFactory.getLogger(PrefixChangerFrame.class);
    private static final String POS_SYSTEM_ID = "POST_SYSTEM_ID";
    private static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    private static final String STORE_ID = "STORE_ID";
    private static final String IDOC_READ_LOC = "IDOC_READ_LOC";
    private static final String ALT_POS_ID = "ALT_POS_ID";
    private static final String RESTORE_CCO_CUR_PATH = "RESTORE_CCO_CUR_";
    private static final String RESTORE_CCO_NEW_PATH = "RESTORE_CCO_NEW_";
    private static final int POSITION_CUR_FIELD = 1;
    private static final int POSITION_NEW_FIELD = 3;

    public PrefixChangerFrame(NextFrameListener listener) {
        JLabel labelToolName = new JLabel(Translator.T((String)"RESTORE_PREFIX_CHANGER_TITEL"));
        this.add(labelToolName);
        this.yPosition += 30;
        JLabel labelPath = new JLabel(Translator.T((String)"RESTORE_CCO_PATH"));
        this.add(labelPath);
        JTextField textFieldCCO = new JTextField();
        textFieldCCO.setText(new File("").getAbsolutePath());
        this.add(textFieldCCO);
        this.yPosition += 30;
        JButton buttonConnect = new JButton(Translator.T((String)"RESTORE_CCO_CONNECT_BUTTON"));
        this.add(buttonConnect);
        buttonConnect.addActionListener(event -> this.showInProgress(Translator.T((String)"RESTORE_INFO_CONNECTING"), () -> {
            textFieldCCO.setEnabled(false);
            buttonConnect.setEnabled(false);
            boolean connectionFailed = false;
            File file = new File(SecurityHelpers.getSecurePath((String)textFieldCCO.getText()));
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_DIRECTORY_NOT_FOUND"));
                connectionFailed = true;
            } else {
                connectionFailed = this.connectToCCO(textFieldCCO);
            }
            if (connectionFailed) {
                textFieldCCO.setEnabled(true);
                buttonConnect.setEnabled(true);
            } else {
                this.ccoHelper = CCOHelper.getInstance();
                this.settingsChanger = new SettingsChanger();
                this.addSettingsFields();
                if (this.updateCurrentValueLabels()) {
                    this.updateSettingsFieldsVisibility(true);
                    this.enableSettingsFields(true);
                    this.btnChangeSettings.setVisible(true);
                    this.btnChangeSettings.setEnabled(true);
                } else {
                    this.btnChangeSettings.setEnabled(false);
                    textFieldCCO.setEnabled(true);
                    buttonConnect.setEnabled(true);
                    this.enableSettingsFields(false);
                }
            }
        }));
        this.buttonNextScreen.addActionListener(e -> listener.openNextFrame(this, this.ccoHelper, null, this.ccoPrefix));
        this.pack();
        SwingUtilities.invokeLater(() -> {
            this.revalidate();
            this.repaint();
        });
    }

    private boolean connectToCCO(JTextField textFieldCCO) {
        try {
            CCOHelper.init(textFieldCCO.getText());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_WRONG_CCO_PATH"));
            logger.error("Could not find a CCO installation in this directory", (Throwable)e);
            return true;
        }
        catch (IllegalStateException e) {
            logger.debug("CCOHelper has been already initialized.");
        }
        return false;
    }

    private void addChangeSettingsButton() {
        this.yPosition += 30;
        this.btnChangeSettings = new JButton(Translator.T((String)"RESTORE_CCO_CHANGE_SETTINGS_BUTTON"));
        this.add(this.btnChangeSettings);
        this.btnChangeSettings.addActionListener(event -> {
            SettingsChangeResult changeResult = this.settingsChanger.changeSettings(this.getCashDeskSettings(), this.getERPSettings());
            if (changeResult.isValidationFailed()) {
                JOptionPane.showMessageDialog(this, changeResult.getErrorMessage(), Translator.T((String)"RESTORE_EXCEPTION_SETTINGS_CHANGE"), 0);
                return;
            }
            if (!this.updateCurrentValueLabels()) {
                return;
            }
            this.btnChangeSettings.setEnabled(false);
            this.enableSettingsFields(false);
            this.buttonNextScreen.setVisible(true);
            JOptionPane.showMessageDialog(this, changeResult.getFinalMessage());
        });
    }

    private void resizeIFrame(int deltaY) {
        Rectangle bounds = this.getBounds();
        this.setBounds(bounds.x, bounds.y - deltaY, bounds.width, bounds.height + 2 * deltaY);
    }

    private void adjustNextButtonPosition() {
    }

    private void addSettingsFields() {
        if (this.isSettingsComponentsAdded) {
            return;
        }
        this.addSettingsField(POS_SYSTEM_ID);
        this.addSerialNumberSettingsField();
        if (this.ccoHelper.isERPSupported()) {
            this.addSettingsField(STORE_ID);
            this.addSettingsField(IDOC_READ_LOC);
            this.addSettingsField(ALT_POS_ID);
        }
        this.addChangeSettingsButton();
        this.adjustNextButtonPosition();
        this.resizeIFrame(this.ccoHelper.isERPSupported() ? 130 : 30);
        this.repaint();
        this.isSettingsComponentsAdded = true;
    }

    private void addSettingsField(String fieldName) {
        if (this.changeComponents.get(fieldName) != null) {
            return;
        }
        this.yPosition += 50;
        JLabel lblCurField = new JLabel(Translator.T((String)(RESTORE_CCO_CUR_PATH + fieldName)));
        JLabel lblCurFieldValue = new JLabel();
        this.yPosition += 20;
        JLabel lblNewField = new JLabel(Translator.T((String)(RESTORE_CCO_NEW_PATH + fieldName)));
        JTextField txtNewField = new JTextField();
        List<Component> components = Arrays.asList(lblCurField, lblCurFieldValue, lblNewField, txtNewField);
        components.forEach(this::add);
        this.changeComponents.put(fieldName, components);
    }

    private void addSerialNumberSettingsField() {
        if (this.changeComponents.get(SERIAL_NUMBER) != null) {
            return;
        }
        this.yPosition += 50;
        JLabel lblCurField = new JLabel(Translator.T((String)"RESTORE_CCO_CUR_SERIAL_NUMBER"));
        JLabel lblCurFieldValue = new JLabel();
        this.yPosition += 20;
        JLabel lblNewField = new JLabel(Translator.T((String)"RESTORE_CCO_RESET_SERIAL_NUMBER"));
        JCheckBox checkbox = new JCheckBox();
        List<Component> components = Arrays.asList(lblCurField, lblCurFieldValue, lblNewField, checkbox);
        components.forEach(this::add);
        this.changeComponents.put(SERIAL_NUMBER, components);
    }

    private boolean updateCurrentValueLabels() {
        boolean isUpdated = false;
        try {
            this.updateCashDeskFieldLabels();
            this.updateERPFieldsLabels();
            isUpdated = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, Translator.T((String)"RESTORE_EXCEPTION_ERP_SETTINGS_UPDATE_ERROR") + "\n");
            logger.error("Failed to read settings", (Throwable)e);
        }
        return isUpdated;
    }

    private void updateCashDeskFieldLabels() {
        CashDeskSettings settings = this.ccoHelper.getCashDeskSettings();
        this.ccoPrefix = Optional.ofNullable(settings.getPrefix()).orElse("");
        String serialNumber = Optional.ofNullable(settings.getSerialNumber()).orElse("");
        this.getSettingsLabelCurrent(POS_SYSTEM_ID).setText(this.ccoPrefix);
        this.getSettingsLabelCurrent(SERIAL_NUMBER).setText(serialNumber);
    }

    private void updateERPFieldsLabels() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            if (this.ccoHelper.isERPSupported()) {
                ERPSettings settings = this.ccoHelper.getLastERPSettings(dbSession);
                this.getSettingsLabelCurrent(STORE_ID).setText(settings.getStoreId());
                this.getSettingsLabelCurrent(IDOC_READ_LOC).setText(settings.getIdocReadLocation());
                this.getSettingsLabelCurrent(ALT_POS_ID).setText(settings.getAlternativePosId());
            }
        }
    }

    private void updateSettingsFieldsVisibility(boolean isVisibile) {
        this.changeComponents.forEach((key, value) -> ((Component)value.get(3)).setVisible(isVisibile));
    }

    private void enableSettingsFields(boolean isEnabled) {
        this.changeComponents.forEach((key, value) -> ((Component)value.get(3)).setEnabled(isEnabled));
    }

    private JTextField getSettingsTextFieldNew(String fieldName) {
        return (JTextField)this.changeComponents.get(fieldName).get(3);
    }

    private JCheckBox getSettingsCheckbox(String fieldName) {
        return (JCheckBox)this.changeComponents.get(fieldName).get(3);
    }

    private JLabel getSettingsLabelCurrent(String fieldName) {
        return (JLabel)this.changeComponents.get(fieldName).get(1);
    }

    private String getSettingsFieldValue(String fieldName) {
        return this.getSettingsTextFieldNew(fieldName).getText();
    }

    private boolean getSettingsCheckboxValue(String fieldName) {
        return this.getSettingsCheckbox(fieldName).isSelected();
    }

    private CashDeskSettings getCashDeskSettings() {
        CashDeskSettings cashDeskSettings = null;
        String newPrefix = this.getSettingsFieldValue(POS_SYSTEM_ID);
        String newSerialNumber = this.getSettingsLabelCurrent(SERIAL_NUMBER).getText();
        if (this.getSettingsCheckboxValue(SERIAL_NUMBER)) {
            newSerialNumber = "";
        }
        if (StringUtils.isNotBlank((CharSequence)newPrefix) || StringUtils.isBlank((CharSequence)newSerialNumber)) {
            cashDeskSettings = new CashDeskSettings(newPrefix, newSerialNumber);
        }
        return cashDeskSettings;
    }

    private ERPSettings getERPSettings() {
        ERPSettings erpSettings = null;
        if (this.ccoHelper.isERPSupported()) {
            String newStoreId = this.getSettingsFieldValue(STORE_ID);
            String newIdocReadLocation = this.getSettingsFieldValue(IDOC_READ_LOC);
            String newAltPosId = this.getSettingsFieldValue(ALT_POS_ID);
            if (StringUtils.isNotBlank((CharSequence)newStoreId) || StringUtils.isNotBlank((CharSequence)newIdocReadLocation) || StringUtils.isNotBlank((CharSequence)newAltPosId)) {
                erpSettings = new ERPSettings(newStoreId, newIdocReadLocation, newAltPosId);
            }
        }
        return erpSettings;
    }
}

