/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.frame.base;

import com.sap.customercheckout.tools.restore.frame.backuprecovery.ProgressAction;
import com.sap.scco.util.translation.Translator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFrame
extends JFrame {
    protected static final int LABEL_LENGTH = 200;
    protected static final int TEXT_FIELD_START = 240;
    protected static final int TEXT_FIELD_LENGTH = 200;
    protected static final int LABEL_LENGTH_LONG = 250;
    protected static final int TEXT_FIELD_START_LONG = 290;
    protected static final int TEXT_FIELD_LENGTH_LONG = 300;
    private static final int FRAME_WIDTH = 380;
    private static final int FRAME_HEIGHT = 700;
    private static final Logger logger = LoggerFactory.getLogger(BaseFrame.class);
    protected final JButton buttonNextScreen;
    protected final JButton buttonFinishScreen;

    public BaseFrame() {
        this.setTitle(Translator.T((String)"RESTORE_TOOL_NAME"));
        this.setLayout(new FlowLayout());
        this.setPreferredSize(new Dimension(380, 700));
        this.setDefaultCloseOperation(3);
        this.buttonNextScreen = new JButton(Translator.T((String)"RESTORE_NEXT_BUTTON"));
        this.buttonNextScreen.setVisible(false);
        this.add(this.buttonNextScreen);
        this.buttonFinishScreen = new JButton(Translator.T((String)"RESTORE_FINISH_BUTTON"));
        this.buttonFinishScreen.setVisible(false);
        this.add(this.buttonFinishScreen);
        this.buttonFinishScreen.addActionListener(e -> {
            this.dispose();
            System.exit(0);
        });
    }

    protected void showInProgress(String prgressMessage, final ProgressAction action) {
        final JDialog loading = new JDialog(this);
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)new JLabel(prgressMessage), "Center");
        loading.setUndecorated(true);
        loading.getContentPane().add(p1);
        loading.pack();
        loading.setLocationRelativeTo(this);
        loading.setDefaultCloseOperation(0);
        loading.setModal(true);
        SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws InterruptedException {
                action.execute();
                return "Finish";
            }

            @Override
            protected void done() {
                loading.dispose();
            }
        };
        worker.execute();
        loading.setVisible(true);
        try {
            worker.get();
        }
        catch (Exception e1) {
            if (e1 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.error("Failed to get worker", (Throwable)e1);
        }
    }
}

