/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.helper;

import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.CashDeskSettings;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.ERPSettings;
import com.sap.scco.ap.configuration.ConfigurationBridgeImpl;
import com.sap.scco.ap.configuration.ConfigurationHelper;
import com.sap.scco.ap.helper.timezone.UTCConvert;
import com.sap.scco.ap.pos.dao.CDBSession;
import com.sap.scco.ap.pos.dao.CDBSessionFactory;
import com.sap.scco.ap.pos.dao.CashDeskManager;
import com.sap.scco.ap.pos.dto.InteroperabilityDTO;
import com.sap.scco.ap.pos.entity.CashDeskClosingEntity;
import com.sap.scco.ap.pos.entity.CashDeskEntity;
import com.sap.scco.ap.pos.entity.i14y.EccIntegrationSettingsEntity;
import com.sap.scco.ap.pos.security.EncryptionHandler;
import com.sap.scco.ap.pos.security.EncryptionService;
import com.sap.scco.ap.pos.service.CashDeskClosingPosService;
import com.sap.scco.ap.pos.service.SecurityPosService;
import com.sap.scco.ap.pos.service.ServiceFactory;
import com.sap.scco.ap.services.CServiceAdaptor;
import com.sap.scco.hl.CPOSDevices;
import com.sap.scco.util.conf.CConfig;
import com.sap.scco.util.conf.ConfigurationBridge;
import com.sap.scco.util.conf.ConfigurationProvider;
import com.sap.scco.util.exception.ValidationException;
import com.sap.scco.util.exception.WrongConfigurationException;
import com.sap.scco.util.utilities.SecurityHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaUpdate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCOHelper
implements Serializable {
    private static final long serialVersionUID = -853525290385434295L;
    private String ccoPath;
    private Boolean erpSupported;
    private static CCOHelper instance;
    private static final Logger logger;

    public static synchronized void init(String ccoPath) throws IOException {
        if (instance != null) {
            throw new IllegalStateException("CCOHelper is already initialized.");
        }
        instance = new CCOHelper(ccoPath);
    }

    public static CCOHelper getInstance() {
        if (instance == null) {
            throw new IllegalStateException("CCOHelper has to be initialized first.");
        }
        return instance;
    }

    private CCOHelper(String ccoPath) throws IOException {
        this.ccoPath = ccoPath;
        File file = new File(SecurityHelpers.getSecurePath((String)(ccoPath + File.separator + "cco" + File.separator + "conf" + File.separator + "customerCheckout.properties")));
        try (FileInputStream inputStream = new FileInputStream(file);){
            Properties props = new Properties();
            props.load(inputStream);
            CConfig.INSTANCE.setCCOProperties(props);
        }
        this.setUpCCOConnection();
    }

    CCOHelper() {
    }

    public boolean isERPSupported() {
        if (this.erpSupported == null) {
            try {
                this.erpSupported = InteroperabilityDTO.SupportedSystem.ECC.equals((Object)ConfigurationHelper.INSTANCE.getErpSystem().getSupportedSystem());
            }
            catch (WrongConfigurationException e) {
                logger.warn("ERP system is not configured.");
                return false;
            }
        }
        return this.erpSupported;
    }

    public void changePrefix(String newPrefix) throws ValidationException {
        CDBSession dbSession = CDBSessionFactory.instance.createSession();
        dbSession.beginTransaction();
        try {
            CashDeskManager cashDeskManager = new CashDeskManager(dbSession);
            cashDeskManager.validatePrefix(newPrefix);
        }
        catch (ValidationException e) {
            dbSession.commitTransaction();
            dbSession.closeDBSession();
            throw e;
        }
        try {
            Query query = dbSession.getEM().createNativeQuery("UPDATE CCO.CASH_DESKS SET PREFIX = ?");
            query.setParameter(1, (Object)newPrefix);
            query.executeUpdate();
            dbSession.commitTransaction();
        }
        catch (Exception e) {
            logger.error("Could not update cco prefix", (Throwable)e);
            dbSession.rollbackDBSession();
            throw e;
        }
        finally {
            dbSession.closeDBSession();
        }
    }

    public void changeCashDeskSettings(CashDeskSettings newSettings, CDBSession dbSession) {
        dbSession.beginTransaction();
        CriteriaUpdate erpCriteriaUpdate = dbSession.getEM().getCriteriaBuilder().createCriteriaUpdate(CashDeskEntity.class);
        if (StringUtils.isNotBlank((CharSequence)newSettings.getPrefix())) {
            erpCriteriaUpdate.set("prefix", (Object)newSettings.getPrefix());
        }
        if (StringUtils.isBlank((CharSequence)newSettings.getSerialNumber())) {
            erpCriteriaUpdate.set("serialNumber", (Object)"");
        }
        Query query = dbSession.getEM().createQuery(erpCriteriaUpdate);
        query.executeUpdate();
        dbSession.commitTransaction();
    }

    public void changeERPSettings(ERPSettings erpSettings, CDBSession dbSession) {
        dbSession.beginTransaction();
        CriteriaUpdate erpCriteriaUpdate = dbSession.getEM().getCriteriaBuilder().createCriteriaUpdate(EccIntegrationSettingsEntity.class);
        if (StringUtils.isNotBlank((CharSequence)erpSettings.getStoreId())) {
            erpCriteriaUpdate.set("storeID", (Object)erpSettings.getStoreId());
        }
        if (StringUtils.isNotBlank((CharSequence)erpSettings.getIdocReadLocation())) {
            erpCriteriaUpdate.set("idocReadPath", (Object)erpSettings.getIdocReadLocation());
        }
        if (StringUtils.isNotBlank((CharSequence)erpSettings.getAlternativePosId())) {
            erpCriteriaUpdate.set("alternativePosId", (Object)erpSettings.getAlternativePosId());
        }
        Query query = dbSession.getEM().createQuery(erpCriteriaUpdate);
        query.executeUpdate();
        dbSession.commitTransaction();
    }

    public ERPSettings getLastERPSettings(CDBSession dbSession) {
        ERPSettings erpSettings = new ERPSettings();
        TypedQuery typedQuery = dbSession.getEM().createQuery("SELECT new com.sap.customercheckout.tools.restore.frame.prefixchanger.util.ERPSettings(intg.storeID, intg.idocReadPath, intg.alternativePosId) FROM EccIntegrationSettingsEntity intg order by intg.createdAt desc", ERPSettings.class);
        List resultList = typedQuery.getResultList();
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            erpSettings = (ERPSettings)resultList.get(0);
        }
        return erpSettings;
    }

    public void voidNewReceipts() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            dbSession.beginTransaction();
            Query query = dbSession.getEM().createNativeQuery("UPDATE RECEIPT SET STATUS=?, ERP_POSTING_STATUS=?, CS_POSTING_STATUS=? WHERE STATUS=? OR STATUS=?");
            query.setParameter(1, (Object)"6");
            query.setParameter(2, (Object)1);
            query.setParameter(3, (Object)1);
            query.setParameter(4, (Object)"1");
            query.setParameter(5, (Object)"4");
            query.executeUpdate();
            dbSession.commitTransaction();
        }
        catch (Exception e) {
            logger.error("Transaction could not be executed successfully.", (Throwable)e);
        }
    }

    public void changeSequenceNumber(String currentSequenceNumber, String sequenceNumberType) {
        sequenceNumberType = StringUtils.upperCase((String)sequenceNumberType);
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            dbSession.beginTransaction();
            Query query = dbSession.getEM().createNativeQuery("UPDATE CCO.SEQUENCENUMBER SET CURRENTNUMBER = ? WHERE upper(NAME) = upper(?)");
            query.setParameter(1, (Object)currentSequenceNumber);
            query.setParameter(2, (Object)sequenceNumberType);
            query.executeUpdate();
            dbSession.commitTransaction();
        }
    }

    public String getCashDeskPrefix() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            Query query = dbSession.getEM().createNativeQuery("SELECT PREFIX FROM CCO.CASH_DESKS");
            List resultList = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                String string = (String)resultList.get(0);
                return string;
            }
            String string = "";
            return string;
        }
    }

    public CashDeskSettings getCashDeskSettings() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            CashDeskSettings settings = new CashDeskSettings();
            String query = "SELECT new com.sap.customercheckout.tools.restore.frame.prefixchanger.util.CashDeskSettings(cashdesk.prefix, cashdesk.serialNumber) FROM CashDeskEntity cashdesk";
            TypedQuery typedQuery = dbSession.getEM().createQuery(query, CashDeskSettings.class);
            List resultList = typedQuery.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                settings = (CashDeskSettings)resultList.get(0);
            }
            CashDeskSettings cashDeskSettings = settings;
            return cashDeskSettings;
        }
    }

    public String getSequenceNumberPattern(String patterName) {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            patterName = StringUtils.upperCase((String)patterName);
            Query query = dbSession.getEM().createNativeQuery("SELECT PATTERN FROM SEQUENCENUMBER WHERE UPPER(NAME) = ?");
            query.setParameter(1, (Object)patterName);
            List resultList = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                String string = String.valueOf(resultList.get(0));
                return string;
            }
        }
        return "";
    }

    public String getSequenceNumberCurrentNumber(String patterName) {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            patterName = StringUtils.upperCase((String)patterName);
            Query query = dbSession.getEM().createNativeQuery("SELECT CURRENTNUMBER FROM SEQUENCENUMBER WHERE UPPER(NAME) = UPPER(?)");
            query.setParameter(1, (Object)patterName);
            List resultList = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                String string = String.valueOf(resultList.get(0));
                return string;
            }
        }
        return "";
    }

    public String getLastReceiptId() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            Query query = dbSession.getEM().createNativeQuery("SELECT ID FROM RECEIPT ORDER BY BUSINESSTRANSACTIONDATE DESC FETCH NEXT 1 ROWS ONLY");
            List resultList = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                String string = String.valueOf(resultList.get(0));
                return string;
            }
        }
        return "";
    }

    public String getLastCustomerId() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            Query query = dbSession.getEM().createNativeQuery("SELECT ID FROM BUSINESSPARTNER ORDER BY CREATEDAT FETCH NEXT 1 ROWS ONLY");
            List resultList = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                String string = String.valueOf(resultList.get(0));
                return string;
            }
        }
        return "";
    }

    public String getLastCashDeskClosingId() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            Query query = dbSession.getEM().createNativeQuery("SELECT ID FROM CASHDESKCLOSING ORDER BY CREATEDAT DESC FETCH NEXT 1 ROWS ONLY");
            List resultList = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                String string = String.valueOf(resultList.get(0));
                return string;
            }
        }
        return "";
    }

    public String getLastVoucherId() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            Query query = dbSession.getEM().createNativeQuery("SELECT ID FROM VOUCHER ORDER BY CREATEDAT DESC FETCH NEXT 1 ROWS ONLY");
            List resultList = query.getResultList();
            if (CollectionUtils.isNotEmpty((Collection)resultList)) {
                String string = String.valueOf(resultList.get(0));
                return string;
            }
        }
        return "";
    }

    public void finishCashDeskClosing() {
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            CashDeskClosingPosService cashDeskClosingService = (CashDeskClosingPosService)ServiceFactory.INSTANCE.getOrCreateServiceInstance(CashDeskClosingPosService.class, dbSession);
            CashDeskClosingEntity cDClosing = cashDeskClosingService.findCurrentCashDeskClosing();
            cDClosing = cashDeskClosingService.adjustClosingAssetForCurCashDeskClosing(cDClosing);
            this.updateCDCERPPostingStatus(dbSession, cDClosing);
            if (dbSession.isTransactionActive()) {
                dbSession.commitTransaction();
            }
        }
    }

    private void updateCDCERPPostingStatus(CDBSession dbSession, CashDeskClosingEntity cDClosing) {
        if (!dbSession.isTransactionActive()) {
            dbSession.beginTransaction();
        }
        if (cDClosing == null) {
            logger.info("Day-end closing already closed.");
            return;
        }
        try {
            Query query = dbSession.getEM().createNativeQuery("UPDATE CASHDESKCLOSING SET STATUS = ?, ERP_POSTING_STATUS = ?, CLOSEDAT = ?, CS_POSTING_STATUS = ? WHERE OBJECTKEY = ?");
            query.setParameter(1, (Object)"4");
            query.setParameter(2, (Object)1);
            Date closedAtDate = UTCConvert.getInstance().convertLocalToUTC(Calendar.getInstance().getTime());
            query.setParameter(3, closedAtDate, TemporalType.TIMESTAMP);
            query.setParameter(4, (Object)1);
            query.setParameter(5, (Object)cDClosing.getKey());
            query.executeUpdate();
        }
        catch (Exception e) {
            logger.error("Exception during finishing cash des closing", (Throwable)e);
            dbSession.rollbackDBSession();
        }
    }

    private void setUpCCOConnection() {
        String path = this.ccoPath.replace("\\", "/");
        CConfig.setRootPath((String)path);
        CServiceAdaptor.getInstance().initDatabaseService();
        CServiceAdaptor.getInstance().startDatabase();
        ConfigurationProvider.INSTANCE.init((ConfigurationBridge)new ConfigurationBridgeImpl());
        SecurityPosService securityPosService = (SecurityPosService)ServiceFactory.INSTANCE.getOrCreateServiceInstance(SecurityPosService.class);
        EncryptionHandler.INSTANCE.initialize((EncryptionService)securityPosService);
        ServiceFactory.INSTANCE.initRestClients();
        CPOSDevices.getInstance().start();
    }

    public void validateSettings(CashDeskSettings cashDeskSettings, ERPSettings erpSettings) throws ValidationException {
        this.validateCashDeskSettings(cashDeskSettings);
        this.validateERPSettings(erpSettings);
    }

    protected void validateCashDeskSettings(CashDeskSettings settings) throws ValidationException {
        if (settings == null) {
            return;
        }
        String prefix = settings.getPrefix();
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return;
        }
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            CashDeskManager cashDeskManager = new CashDeskManager(dbSession);
            if (!StringUtils.isBlank((CharSequence)prefix)) {
                cashDeskManager.validatePrefix(prefix);
            }
        }
    }

    protected void validateERPSettings(ERPSettings erpSettings) throws ValidationException {
        if (erpSettings == null) {
            return;
        }
        if (StringUtils.length((CharSequence)erpSettings.getStoreId()) > 40) {
            throw new ValidationException("RESTORE_EXCEPTION_STORE_ID_TOO_LONG");
        }
        if (StringUtils.length((CharSequence)erpSettings.getIdocReadLocation()) > 255) {
            throw new ValidationException("RESTORE_EXCEPTION_IDOC_READ_LOC_TOO_LONG");
        }
        if (StringUtils.length((CharSequence)erpSettings.getAlternativePosId()) > 255) {
            throw new ValidationException("RESTORE_EXCEPTION_ALT_POS_ID_TO_LONG");
        }
    }

    static {
        logger = LoggerFactory.getLogger(CCOHelper.class);
    }
}

