/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.frame.prefixchanger.util;

import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.CashDeskSettings;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.ERPSettings;
import com.sap.customercheckout.tools.restore.frame.prefixchanger.util.SettingsChangeResult;
import com.sap.customercheckout.tools.restore.helper.CCOHelper;
import com.sap.scco.ap.pos.dao.CDBSession;
import com.sap.scco.ap.pos.dao.CDBSessionFactory;
import com.sap.scco.util.exception.ValidationException;
import com.sap.scco.util.translation.Translator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsChanger {
    private static final Logger logger = LoggerFactory.getLogger(SettingsChanger.class);

    public SettingsChangeResult changeSettings(CashDeskSettings cashDeskSettings, ERPSettings erpSettings) {
        SettingsChangeResult result = new SettingsChangeResult();
        this.validateSettings(cashDeskSettings, erpSettings, result);
        if (!result.isValidationFailed()) {
            this.changeCashDeskSettings(cashDeskSettings, result);
            this.changeERPSettings(erpSettings, result);
        }
        return result;
    }

    private void validateSettings(CashDeskSettings cashDeskSettings, ERPSettings erpSettings, SettingsChangeResult result) {
        try {
            CCOHelper.getInstance().validateSettings(cashDeskSettings, erpSettings);
        }
        catch (ValidationException e) {
            result.appendError(Translator.T((String)"RESTORE_EXCEPTION_SETTINGS_CHANGE"));
            result.appendError(Translator.T((String)e.getMessage()));
            result.setValidationFailed(true);
        }
    }

    private void changeCashDeskSettings(CashDeskSettings cashDeskSettings, SettingsChangeResult result) {
        if (cashDeskSettings == null) {
            return;
        }
        CCOHelper ccoHelper = CCOHelper.getInstance();
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            ccoHelper.changeCashDeskSettings(cashDeskSettings, dbSession);
            if (StringUtils.isNotBlank((CharSequence)cashDeskSettings.getPrefix())) {
                result.appendSuccess("RESTORE_MSG_POS_SYSTEM_ID_CHANGED");
            }
            ccoHelper.voidNewReceipts();
        }
        catch (Exception e) {
            result.appendError(Translator.T((String)"RESTORE_EXCEPTION_CASH_DESK_SETTINGS_CHANGE"));
            result.appendError(Translator.T((String)e.getMessage()));
            logger.error("Failed to change cash desk settings", (Throwable)e);
            return;
        }
        try {
            ccoHelper.finishCashDeskClosing();
            result.appendSuccess("RESTORE_MSG_CDC_CHANGED");
        }
        catch (Exception e) {
            result.appendError(Translator.T((String)"RESTORE_EXCEPTION_CDC_CHANGE"));
            result.appendError(e.getMessage());
            logger.error("Failed to finish day end closing", (Throwable)e);
        }
    }

    private void changeERPSettings(ERPSettings erpSettings, SettingsChangeResult result) {
        CCOHelper ccoHelper = CCOHelper.getInstance();
        if (!ccoHelper.isERPSupported() || erpSettings == null) {
            return;
        }
        try (CDBSession dbSession = CDBSessionFactory.instance.createSession();){
            ccoHelper.changeERPSettings(erpSettings, dbSession);
            if (StringUtils.isNotBlank((CharSequence)erpSettings.getStoreId())) {
                result.appendSuccess("RESTORE_MSG_STORE_ID_CHANGED");
            }
            if (StringUtils.isNotBlank((CharSequence)erpSettings.getIdocReadLocation())) {
                result.appendSuccess("RESTORE_MSG_IDOC_READ_LOC_CHANGED");
            }
            if (StringUtils.isNotBlank((CharSequence)erpSettings.getAlternativePosId())) {
                result.appendSuccess("RESTORE_MSG_ALT_POS_ID_CHANGED");
            }
        }
        catch (Exception e) {
            logger.error("Failed to change ERP settings", (Throwable)e);
            result.appendError(Translator.T((String)"RESTORE_EXCEPTION_ERP_SETTINGS_CHANGE"));
            result.appendError(e.getMessage());
        }
    }
}

