/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.helper;

import com.sap.scco.util.utilities.SecurityHelpers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FileHelper {
    INSTANCE;

    private static final Logger logger;

    public void unzipFile(String zipFileDirectory, String outputDirectory) throws IOException {
        File folder = new File(SecurityHelpers.getSecurePath((String)outputDirectory));
        if (!folder.exists()) {
            folder.mkdir();
        }
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(SecurityHelpers.getSecurePath((String)zipFileDirectory)));){
            ZipEntry ze = zis.getNextEntry();
            byte[] buffer = new byte[1024];
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(SecurityHelpers.getSecurePath((String)outputDirectory), SecurityHelpers.getSecurePath((String)fileName));
                String canonicalDestinationPath = newFile.getCanonicalPath();
                if (!canonicalDestinationPath.startsWith(outputDirectory)) {
                    throw new IOException("Entry is outside of the target directory");
                }
                new File(newFile.getParent()).mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                ze = zis.getNextEntry();
            }
        }
    }

    public String renameDirectory(String direcotryPath, String newDirectoryName) {
        File dir = new File(SecurityHelpers.getSecurePath((String)direcotryPath));
        if (dir.exists()) {
            File newDir = new File(dir.getParent(), newDirectoryName);
            boolean successfullyRenamed = dir.renameTo(newDir);
            if (!successfullyRenamed) {
                throw new IllegalStateException("Could not rename directory. Directory might be locked.");
            }
            dir = newDir;
        }
        return dir.getAbsolutePath();
    }

    static {
        logger = LoggerFactory.getLogger(FileHelper.class);
    }
}

