/*
 * Decompiled with CFR 0.152.
 */
package com.sap.customercheckout.tools.restore.frame.base;

import com.sap.customercheckout.tools.restore.controller.NextFrameListener;
import com.sap.customercheckout.tools.restore.frame.base.BaseFrame;
import com.sap.customercheckout.tools.restore.helper.CCOHelper;
import com.sap.scco.util.translation.Translator;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSequenceNumberFrame
extends BaseFrame {
    private static final Logger logger = LoggerFactory.getLogger(BaseSequenceNumberFrame.class);
    protected int yPosition = 20;
    protected JLabel frameTitle;
    protected JLabel labelPattern;
    protected JLabel labelLastIdFromManagerText;
    protected JLabel labelLastIdFromManagerValue;
    protected JLabel labelCurrentIdInCCO;
    protected JLabel labelCurrentSequenceNumber;
    protected JTextField textFieldSequenceNumber;
    protected JButton buttonChangeSequenceNumber;

    public BaseSequenceNumberFrame(NextFrameListener listener, final CCOHelper helper, String squenceNumberName, final String sequenceNumberType, final boolean lastScreen) {
        this.frameTitle = new JLabel(Translator.T((String)"RESTORE_CCO_CHANGE_SEQUENCE_NUMBER_TITLE", (Object[])new Object[]{squenceNumberName}));
        this.frameTitle.setBounds(20, this.yPosition, 300, 20);
        this.add(this.frameTitle);
        this.yPosition += 40;
        JLabel pattern = new JLabel(Translator.T((String)"RESTORE_CCO_SEQUENCE_NUMBER_PATTERN"));
        pattern.setBounds(20, this.yPosition, 200, 20);
        this.add(pattern);
        this.labelPattern = new JLabel("");
        this.labelPattern.setBounds(290, this.yPosition, 300, 20);
        this.add(this.labelPattern);
        this.yPosition += 20;
        this.labelLastIdFromManagerText = new JLabel("<html>" + Translator.T((String)"RESTORE_CCO_LAST_SEQUENCE_NUMBER", (Object[])new Object[]{squenceNumberName}) + "</html>");
        this.labelLastIdFromManagerText.setBounds(20, this.yPosition, 250, 40);
        this.add(this.labelLastIdFromManagerText);
        this.yPosition += 20;
        this.labelLastIdFromManagerValue = new JLabel("");
        this.labelLastIdFromManagerValue.setBounds(290, this.yPosition, 200, 20);
        this.add(this.labelLastIdFromManagerValue);
        this.yPosition += 20;
        JLabel currentId = new JLabel(Translator.T((String)"RESTORE_CCO_CURRENT_SEQUENCE_NUMBER", (Object[])new Object[]{squenceNumberName}));
        currentId.setBounds(20, this.yPosition, 250, 20);
        this.add(currentId);
        this.labelCurrentIdInCCO = new JLabel("");
        this.labelCurrentIdInCCO.setBounds(290, this.yPosition, 200, 20);
        this.add(this.labelCurrentIdInCCO);
        this.yPosition += 20;
        JLabel currentSequenceNumber = new JLabel(Translator.T((String)"RESTORE_CCO_CURRENT_SEQUENCE_NUMBER_FIELD"));
        currentSequenceNumber.setBounds(20, this.yPosition, 250, 20);
        this.add(currentSequenceNumber);
        this.labelCurrentSequenceNumber = new JLabel("");
        this.labelCurrentSequenceNumber.setBounds(290, this.yPosition, 200, 20);
        this.add(this.labelCurrentSequenceNumber);
        this.yPosition += 40;
        JLabel labelSequenceNumber = new JLabel(Translator.T((String)"RESTORE_CCO_NEW_SEQUENCE_NUMBER_FIELD"));
        labelSequenceNumber.setBounds(20, this.yPosition, 250, 20);
        this.add(labelSequenceNumber);
        this.textFieldSequenceNumber = new JTextField();
        this.textFieldSequenceNumber.setBounds(290, this.yPosition, 200, 20);
        this.add(this.textFieldSequenceNumber);
        this.yPosition += 30;
        this.buttonChangeSequenceNumber = new JButton(Translator.T((String)"RESTORE_CCO_CHANGE_SEQUENCE_NUMBER", (Object[])new Object[]{squenceNumberName}));
        this.buttonChangeSequenceNumber.setBounds(20, this.yPosition, 300, 20);
        this.add(this.buttonChangeSequenceNumber);
        this.buttonChangeSequenceNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String sequenceNumber = BaseSequenceNumberFrame.this.textFieldSequenceNumber.getText();
                if (!sequenceNumber.isEmpty() && !sequenceNumber.matches("[0-9]+")) {
                    JOptionPane.showMessageDialog(BaseSequenceNumberFrame.this, Translator.T((String)"RESTORE_EXCEPTION_SEQUENCE_NUMBER_ONLY_NUMBERS"));
                    return;
                }
                BaseSequenceNumberFrame.this.textFieldSequenceNumber.setEnabled(false);
                BaseSequenceNumberFrame.this.buttonChangeSequenceNumber.setEnabled(false);
                try {
                    if (!sequenceNumber.isEmpty()) {
                        helper.changeSequenceNumber(BaseSequenceNumberFrame.this.textFieldSequenceNumber.getText(), sequenceNumberType);
                        JOptionPane.showMessageDialog(BaseSequenceNumberFrame.this, Translator.T((String)"RESTORE_MSG_SEQUENCE_NUMBER_CHANGED"));
                    }
                }
                catch (Exception e) {
                    logger.error("Could not change sequence number", (Throwable)e);
                    JOptionPane.showMessageDialog(BaseSequenceNumberFrame.this, Translator.T((String)"RESTORE_EXCEPTION_SEQUENCE_NUMBER_CHANGE") + e.getMessage());
                }
                try {
                    BaseSequenceNumberFrame.this.labelCurrentSequenceNumber.setText(helper.getSequenceNumberCurrentNumber(sequenceNumberType));
                }
                catch (Exception e) {
                    logger.error("Could not read sequence number", (Throwable)e);
                }
                if (lastScreen) {
                    BaseSequenceNumberFrame.this.buttonFinishScreen.setVisible(true);
                } else {
                    BaseSequenceNumberFrame.this.buttonNextScreen.setVisible(true);
                }
            }
        });
    }

    protected String getSequenceNumberSuggestion(String sequenceNumberPattern, String lastReceiptFromServer, String sequenceNumberFromPos) {
        if (lastReceiptFromServer != null && sequenceNumberPattern != null && sequenceNumberPattern.endsWith("${number?string(\"00000000\")}")) {
            String numberSuggestion;
            logger.info("Default sequence number pattern");
            int beginIndex = lastReceiptFromServer.length() - 8;
            if (beginIndex >= 0 && (numberSuggestion = lastReceiptFromServer.substring(beginIndex)).matches("[0-9]+")) {
                Integer numberSuggestionInteger = Integer.valueOf(numberSuggestion);
                if (numberSuggestionInteger >= Integer.valueOf(sequenceNumberFromPos)) {
                    return numberSuggestionInteger.toString();
                }
                return sequenceNumberFromPos;
            }
        }
        return "";
    }

    protected void setSequenceNumberFields(String ccoPrefix, String currentSquenceNumber, String sequenceNumberPattern, String lastId, String lastIdFromManager) {
        this.labelPattern.setText(sequenceNumberPattern);
        this.labelCurrentSequenceNumber.setText(currentSquenceNumber);
        this.labelCurrentIdInCCO.setText(lastId);
        if (lastIdFromManager == null) {
            lastIdFromManager = "n/a with prefix-" + ccoPrefix;
            this.labelLastIdFromManagerValue.setForeground(Color.RED);
        }
        this.labelLastIdFromManagerValue.setText((String)lastIdFromManager);
        this.textFieldSequenceNumber.setText(this.getSequenceNumberSuggestion(sequenceNumberPattern, (String)lastIdFromManager, currentSquenceNumber));
    }
}

